/*
 * Toolkit GUI, an application built for operating pinkRF's signal generators.
 *
 * Contact: https://www.pinkrf.com/contact/
 * Copyright © 2018-2024 pinkRF B.V
 * GNU General Public License version 3.
 *
 * This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License along with this program. If not, see https://www.gnu.org/licenses/
 *
 * Author: Iordan Svechtarov
 */

#ifndef LOGGINGCLASS_H
#define LOGGINGCLASS_H

#include <QTimer>
#include <QElapsedTimer>
#include <QFile>
#include <QMap>

class LoggingClass : public QObject
{
	Q_OBJECT

public:
	LoggingClass(int logging_rate, QString directory, QString filename, QStringList columns);
	~LoggingClass();

	bool setData (int column_index, QString Data);
	bool setData(QString column_name, QString Data);
	void enable_datalogging(bool enable);


private:
	QElapsedTimer elapsedTimer;
	QTimer *logTimer;
	QFile *logfile;

	int logging_rate = 1000;
	QString directory = "";
	QString filename = "";
	QString generate_filepath();

	bool firstRun = true;

	QStringList data_columns;
	QMap<uint,QString> dataMap;

	bool storage_available();
	bool storage_full();
	bool free_up_storage();
	bool createFile();
	QString getRunTime();
	bool writeColumns();
	bool writeData();

private slots:
	bool dataLogger();

signals:
	void signal_datalogging_enable(bool enable);
	void signal_datalogging_storage_sufficient(bool storage_sufficient);
	void signal_datalogging_log_deleted(bool succes, QString filename);
	//signal_datalogging_enable(bool enable, QString error);

};
#endif // LOGGINGCLASS_H


